#!/bin/bash

# Runs the Validate External Links script
# Arguments: --help, --links URL, --exceptions URL, --output DIR, --record-ok-links, --show-added-slashes,
# --show-https-upgrades, --show-yt-redirects, --suggest-snapshots-ng, --suggest-snapshots-ok,
# --check-archive-links, --take-screenshots FILE, --timeout NUM, --start-url NUM, --end-url NUM, --upload FILE
# Recommended rule:
# |----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ----- ---|

# Set variables for any arguments we might use below
VALEXTLINKS="/path/to/Validate External Links/validate_external_links.sh"
LINKS_LOCAL="file:///path/to/Validate External Links/Sample files/extlinks.csv"
LINKS_ONLINE="https://wiki.oni2.net/w/extlinks.csv"
EXCEPT_LOCAL="file:///path/to/Validate External Links/exceptions.txt"
EXCEPT_ONLINE="https://wiki.oni2.net/Validate_External_Links/Exceptions"
REPORT_DIR="/path/to/where/you/want/Val Reports"
UPLOAD_INFO="/path/to/Validate External Links/sftp_login.txt"
CHROME="/Applications/Google Chrome.app/Contents/MacOS/Google Chrome"


# Run with start/end URLs, record OK codes, and don't upload
#bash "$VALEXTLINKS" --links "$LINKS_ONLINE" --exceptions "$EXCEPT_ONLINE" --output "$REPORT_DIR" --record-ok-links --suggest-snapshots-ng --timeout 10 --show-https-upgrades --show-added-slashes --show-yt-redirects --start-url 445 --end-url 451

# Run with start/end URLs, record OK codes, suggest OK snapshots, and don't upload
#bash "$VALEXTLINKS" --links "$LINKS_ONLINE" --exceptions "$EXCEPT_ONLINE" --output "$REPORT_DIR" --record-ok-links --suggest-snapshots-ng --suggest-snapshots-ok --timeout 10 --show-https-upgrades --show-added-slashes --show-yt-redirects --start-url 445 --end-url 451

# Run with local extlinks and exceptions, start/end URLs, record OK codes, and don't upload
#bash "$VALEXTLINKS" --links "$LINKS_LOCAL" --exceptions "$EXCEPT_LOCAL" --output "$REPORT_DIR" --record-ok-links --suggest-snapshots-ng --start-url 1810 --end-url 1815

# Run with unfinished screenshot feature, no upload
#bash "$VALEXTLINKS" --links "$LINKS_ONLINE" --exceptions "$EXCEPT_ONLINE" --output "$REPORT_DIR" --record-ok-links --take-screenshots "$CHROME"

# Normal run with no upload, snapshot suggestions, https upgrades or added slashes
#bash "$VALEXTLINKS" --links "$LINKS_ONLINE" --exceptions "$EXCEPT_ONLINE" --output "$REPORT_DIR" --timeout 10

# Normal run with no upload
#bash "$VALEXTLINKS" --links "$LINKS_ONLINE" --exceptions "$EXCEPT_ONLINE" --output "$REPORT_DIR" --suggest-snapshots-ng --timeout 10 --show-https-upgrades --show-added-slashes

# Normal run
bash "$VALEXTLINKS" --links "$LINKS_ONLINE" --exceptions "$EXCEPT_ONLINE" --output "$REPORT_DIR" --suggest-snapshots-ng --timeout 10 --show-https-upgrades --show-added-slashes --show-yt-redirects --upload "$UPLOAD_INFO"